<?php


function generateRandomString() {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomLength = rand(5, 8);
    $randomString = '';
    for ($i = 0; $i < $randomLength; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

$randomValue = generateRandomString();

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the request body
    $body = file_get_contents('php://input');
    
    // Extract email and ID from the request body
    $data = json_decode($body, true);
    $emails = $data['email'];
    $id = $data['id'];
    
    // Send the email to each address
    $subject = "Result of sending for item [$id]";
    $message = "item ID: $id is sending out emails you can buy it";
    $headers = "From: $randomValue ";
    
    $sentCount = 0;
    $failedCount = 0;
    foreach ($emails as $email) {
        if (mail($email, $subject, $message, $headers)) {
            $sentCount++;
        } else {
            $failedCount++;
        }
    }
    
    if ($failedCount === 0) {
        $response = 'All emails sent successfully';
    }
    else if(sentCount > 0){
    
            $response = 'some emails sent successfully';
    
    } else {
        $error = error_get_last();
        $response = 'Sent: ' . $sentCount . ', Failed: ' . $failedCount . ' - Error: ' . $error['message'];
    }
} else {
    // Invalid request method
    $response = 'Invalid request method';
}

// Return the response
echo $response;

?>
